//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------
namespace CSCashSales.data_objects
{
	using System;

	/// <summary>
	/// Additional utilities.
	/// </summary>
	public class Utils
	{

		/// <summary>
		/// Constructor.
		/// </summary>
		public Utils()
		{
		}

		/// <summary>
		/// Represents a decimal value as a currency string.
		/// </summary>
		/// <param name="dcmValue"> the specified value </param>
		public static String AsCurrency( Decimal dcmValue ) 
		{
			if(dcmValue != 0 )
				//return Decimal.Format( dcmValue, "0.00" );
				//return String.Format("c",dcmValue);
				return dcmValue.ToString("c");
			else
				return "";
		}

		/// <summary>
		/// Represents an integer value as a currency string.
		/// </summary>
		/// <param name="intValue"> the specified value </param>
		public static String Int2Str( int intValue ) 
		{
			Int32 buf = new Int32();
			buf = intValue;
			return buf.ToString();
		}
	}

}